function [A rowLabels columnLabels] = fillFromFile(fileName,delimiter)
%FILLFROMFILE Used by class AdjacencyMatrix when the constructor is called
%with a filename instead of a matrix.  This will fill from a
%comma-delimited text file
%
%   [A ROWLABELS COLUMNLABELS] = FILLFROMFILE(FILENAME,DELIMITER) Load an
%   adjacency matrix from a comma-delimited text file given by filename.
%   delimiter should be the character which splits the fields in the file;
%   Default value is ','. A is the adjacency matrix, rowlabels is a cell
%   array of strings giving the presynaptic neuron names, columnlabels is a
%   cell array of strings giving the postsynaptic neuron names.

if nargin == 1, delimiter = ','; end

fid = fopen(fileName);

% First line of file should be the column labels
columnLabels = regexp(fgetl(fid),delimiter,'split');
% First column of column labels should be blank, because this is the column
% for the row labels.
columnLabels = columnLabels(2:end);
nColumns = numel(columnLabels);


    
    % Now read the rest of the file
    line = fgetl(fid);
    rowLabels = {};
    i = 1;
    A = sparse([]);
    % build format string for reading line data
    format = strcat('%s',repmat('%u',1,nColumns));
%     format = '%s%u';

    
    while (ischar(line))
        lineData = textscan(line,format,'Delimiter',',','EmptyValue',0,'CollectOutput',true);

        rowLabels = [rowLabels ; lineData{1}];
        tmp = double(lineData{2});
        A(i,:) = sparse(tmp);
        
        
        
        %     splitLine = regexp(line,delimiter,'split');
        %
        %
        %     % First field of splitLine should be the row label
        %     rowLabels = [rowLabels; splitLine{1}];
        %     for j = 2:numel(splitLine)
        %         if(isempty(str2num(splitLine{j})))
        %             A(i,j-1) = 0;
        %         else
        %             A(i,j-1) = str2num(splitLine{j});
        %         end
        %     end
        i = i+1;
        line = fgetl(fid);
    end


fclose(fid);

% Any rows or columns of A that do not have a label will be ignored
A = A(1:numel(rowLabels),1:numel(columnLabels));

end

